/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.common.loot;

import com.google.gson.JsonObject;
import com.yollo.dmlreforged.common.items.ItemDataModel;
import com.yollo.dmlreforged.common.items.ItemDeepLearner;
import com.yollo.dmlreforged.common.items.ItemGlitchArmor;
import com.yollo.dmlreforged.common.mobmetas.MobMetaData;
import com.yollo.dmlreforged.core.configs.BalanceConfigs;
import com.yollo.dmlreforged.core.init.ItemInit;
import com.yollo.dmlreforged.core.util.DataModelHelper;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class GlitchFragmentModifier
extends LootModifier {
    private final Item fragment = (Item)ItemInit.GLITCH_FRAGMENT.get();
    private final Item heart = (Item)ItemInit.GLITCH_HEART.get();
    private final int chanceFragment;
    private final float chanceHeart;
    private final boolean enabled;

    protected GlitchFragmentModifier(LootItemCondition[] conditionsIn, int chanceFragment, float chanceHeart, boolean enabled) {
        super(conditionsIn);
        this.chanceFragment = chanceFragment;
        this.chanceHeart = chanceHeart;
        this.enabled = enabled;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext ctx) {
        if (this.enabled && ctx.m_78953_(LootContextParams.f_81455_) instanceof Enemy) {
            Object object;
            if (ThreadLocalRandom.current().nextInt(1, 100) <= this.chanceFragment) {
                generatedLoot.add(new ItemStack((ItemLike)this.fragment, ThreadLocalRandom.current().nextInt(1, 3)));
            }
            if (ThreadLocalRandom.current().nextFloat(0.0f, 100.0f) <= this.chanceHeart) {
                generatedLoot.add(new ItemStack((ItemLike)this.heart, 1));
            }
            if ((object = ctx.m_78953_(LootContextParams.f_81458_)) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)object;
                NonNullList inventory = NonNullList.m_122779_();
                inventory.addAll((Collection)player.m_150109_().f_35974_);
                inventory.addAll((Collection)player.m_150109_().f_35976_);
                NonNullList<ItemStack> deepLearners = GlitchFragmentModifier.getDeepLearners((NonNullList<ItemStack>)inventory);
                NonNullList updatedModels = NonNullList.m_122779_();
                deepLearners.forEach(stack -> {
                    NonNullList<ItemStack> models = GlitchFragmentModifier.updateAndReturnModels(stack, (LivingEntity)ctx.m_78953_(LootContextParams.f_81455_), player);
                    updatedModels.addAll(models);
                });
                if (updatedModels.size() == 0) {
                    return generatedLoot;
                }
                if (((Boolean)BalanceConfigs.isGlitchArmorExtraDropsEnabled.get()).booleanValue() && ItemGlitchArmor.isSetEquippedByPlayer(player) && ThreadLocalRandom.current().nextInt(1, 100) <= 16) {
                    MobMetaData meta = DataModelHelper.getMobMetaData((ItemStack)updatedModels.get(0));
                    generatedLoot.add(meta.getPristineMatterStack(2));
                }
            }
        }
        return generatedLoot;
    }

    private static NonNullList<ItemStack> updateAndReturnModels(ItemStack deepLearner, LivingEntity entity, ServerPlayer player) {
        NonNullList<ItemStack> deepLearnerItems = ItemDeepLearner.getContainedItems(deepLearner);
        NonNullList result = NonNullList.m_122779_();
        deepLearnerItems.forEach(stack -> {
            MobMetaData meta;
            if (stack.m_41720_() instanceof ItemDataModel && (meta = DataModelHelper.getMobMetaData(stack)).entityLivingMatchesMob(entity)) {
                DataModelHelper.increaseMobKillCount(stack, player);
                result.add(stack);
            }
            ItemDeepLearner.setContainedItems(deepLearner, deepLearnerItems);
        });
        return result;
    }

    private static NonNullList<ItemStack> getDeepLearners(NonNullList<ItemStack> inventory) {
        NonNullList result = NonNullList.m_122779_();
        inventory.forEach(stack -> {
            if (stack.m_41720_() instanceof ItemDeepLearner) {
                result.add(stack);
            }
        });
        return result;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<GlitchFragmentModifier> {
        public GlitchFragmentModifier read(ResourceLocation name, JsonObject object, LootItemCondition[] conditions) {
            int chanceFragment = GsonHelper.m_13927_((JsonObject)object, (String)"chanceFragment");
            float chanceHeart = GsonHelper.m_13915_((JsonObject)object, (String)"chanceHeart");
            boolean enabled = GsonHelper.m_13912_((JsonObject)object, (String)"enabled");
            return new GlitchFragmentModifier(conditions, chanceFragment, chanceHeart, enabled);
        }

        public JsonObject write(GlitchFragmentModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("chanceFragment", (Number)instance.chanceFragment);
            json.addProperty("chanceHeart", (Number)Float.valueOf(instance.chanceHeart));
            json.addProperty("enabled", Boolean.valueOf(instance.enabled));
            return json;
        }
    }
}

